unit f_Report;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ToolWin, ComCtrls, ExtCtrls;

type
  TCustomerData = class(TComponent)
  private
    FCustomerName: string;
    FAdress: string;
    FNumber: integer;
    FVIP: boolean;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Init(AName: string; ANum: integer; AAdr: string; AVIP: boolean);
  published
    property Number: integer read FNumber write FNumber;
    property CustomerName: string read FCustomerName write FCustomerName;
    property Adress: string read FAdress write FAdress;
    property VIP: boolean read FVIP write FVip;
  end;

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Panel1: TPanel;
    Panel2: TPanel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    FObjects: array[0..3] of TCustomerData;
    FBatchList: array[0..1] of TList;
    procedure ReportFormClose1(Sender: TObject; var Action: TCloseAction);
    procedure ReportFormClose2(Sender: TObject; var Action: TCloseAction);
  public
    constructor Create(AOwner: TComponent); override;
  end;

var
  Form1: TForm1;

implementation

uses f_Main;

{$R *.DFM}

procedure TForm1.ReportFormClose1(Sender: TObject; var Action: TCloseAction);
begin
  Button1.Enabled := true;
  Button3.Enabled := false;
  Action := caHide;
end;

procedure TForm1.ReportFormClose2(Sender: TObject; var Action: TCloseAction);
begin
  Button2.Enabled := true;
  Button4.Enabled := false;
  Action := caHide;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Button1.Enabled := false;
  with fmReport.RPF1 do
  begin
    ReportForm.OnClose := ReportFormClose1;
    Visible := false;
    Report.LoadReport('Demo1.gre', true);
    ReportForm.Left := 0;
    ReportForm.Top := 0;
    PageProperties.ViewGrid := false;
    Visible := true;
  end;
  Button3.Enabled := true;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Button2.Enabled := false;
  with fmReport.RPF2 do
  begin
    ReportForm.OnClose := ReportFormClose2;
    Visible := false;
    Report.LoadReport('Demo2.gre', true);
    ReportForm.Left := 0;
    ReportForm.Top := 0;
    PageProperties.ViewGrid := false;
    Visible := true;
  end;
  Button4.Enabled := true;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  fmReport.RPF1.Visible := false;
  Button3.Enabled := false;
  Button1.Enabled := true;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  fmReport.RPF2.Visible := false;
  Button4.Enabled := false;
  Button2.Enabled := true;
end;

constructor TCustomerData.Create(AOwner: TComponent);
begin
  inherited;
  FAdress := '';
  FNumber := 0;
  FVIP := false;
end;

procedure TCustomerData.Init(AName: string; ANum: integer; AAdr: string; AVIP: boolean);
begin
  FCustomerName := AName;
  FAdress := AAdr;
  FNumber := ANum;
  FVIP := AVIP;
end;

constructor TForm1.Create(AOwner: TComponent);
begin
  inherited;
  FObjects[0] := TCustomerData.Create(self);
  FObjects[0].Init('Customer Name', 0, 'Customer Adress', false);
  FObjects[0].Name := 'Customer1';
  FObjects[1] := TCustomerData.Create(self);
  FObjects[1].Init('AB', 2, 'XXXX XXX', true);
  FObjects[1].Name := 'Customer2';
  FObjects[2] := TCustomerData.Create(self);
  FObjects[2].Init('CD', 3, 'YYYY YYY', false);
  FObjects[2].Name := 'Customer3';
  FObjects[3] := TCustomerData.Create(self);
  FObjects[3].Init('EF', 4, 'Z Z Z Z Z', true);
  FObjects[3].Name := 'Customer4';
  FBatchList[0] := TList.Create;
  with FBatchList[0] do
  begin
    Add(FObjects[1]);
    Add(FObjects[2]);
    Add(FObjects[3]);
  end;
  FBatchList[1] := TList.Create;
  with FBatchList[1] do
  begin
    Add(FObjects[2]);
    Add(FObjects[3]);
  end;
end;

end.

